#!/usr/bin/perl
#
$Version = 0.02;
@ARGV = (	"../../release/forums/includes/xml/hooks_ldm.xml",
			"../../release",
		);

#
# Extracts the hooks from $argv[0] and cross-references against hooks in all other arguments
#
# Usage : hooksval.pl
#

use Cwd 'abs_path';

# Find all the .php files in the directory tree under the argument directory
sub findphpfiles {

	my $path = shift(@_);
	my $root = abs_path($path);
	my @filelist = ();
	my $DIR;

	opendir($DIR, $root) || die "can't opendir $root: $!";
	my @files = readdir($DIR);
	closedir $DIR;

FILE:
	foreach my $file (@files) {
		if ($file =~ m{^\.+$}) {
			next FILE;
		}
		my $fullfile = $root.'/'.$file;
		if (-d $fullfile) {
			push @filelist, findphpfiles($fullfile);
		}
		elsif ($fullfile=~/\.php$/) {
			push @filelist, $fullfile;
		}
	}

	return @filelist;

}

$xml = shift @ARGV;
open XML , "<$xml" or die "Unable to open $xml";

$hooklist = "";
while (<XML>) { $hooklist .= $_; }
close XML;

%set_hooks = ();
while ($hooklist =~ m/<hook>(.*?)</gs) {
    $set_hooks{$1} = 0;
}

my @files = findphpfiles(shift @ARGV);

while ($file = shift @files) {
	my $clean = 1;
    open FILE , "<$file" or die "Unable to open $file";
    $hooklist = "";
    while (<FILE>) { $hooklist .= $_; }
    close FILE;
    while ($hooklist =~ m/vBulletinHook::fetch_hook..(.*?)'\)/gs) {
        if (exists $set_hooks{$1}) {
            $set_hooks{$1}++;
        }
        else {
			if ($clean) {
			    print $file."\n";
			    $clean = 0;
			}
            print "Unrecognised: ".$1."\n";
        }
    }
}

print "\n\n";
foreach $k (sort keys %set_hooks) {
    printf "%3d %s\n" , $set_hooks{$k}, $k;
}

